
import cadquery as cq

# Redefined points to adjust the top angles closer to an obtuse (near 180 degrees)
pts = [
    (0, 0),
    (2, 0),
    (2.6, 1),   # Slightly adjusted to simulate a flatter top right side
    (2, 2),
    (0, 2),
    (-0.6, 1)  # Slightly adjusted to simulate a flatter top left side
]

# Create the workplane and draw the polygon by joining all points
result = cq.Workplane("XY").polyline(pts).close()

# Extrude the planar shape by 1 unit height
result = result.extrude(1)

# Export the model as an STL file with refined parameters
result.val().exportStl("Refine_V_1.stl")
