
import cadquery as cq

# Define points to correctly form a pentagon
pts = [
    (0, 0),             # Bottom-left
    (10, 0),            # Bottom-right
    (11, 5),            # Middle of the pentagonal breaking into near 180 degree
    (5, 9),             # Upper point
    (0, 5)              # Left side (connects back to start to create the pentagon)
]

# Create a workplane to draw on, then draw the defined shape and extrude
result = cq.Workplane("XY").polyline(pts).close().extrude(1)

# Break top edge into two edges at an angle close to 180 degrees
# Points (10, 0) to (11, 5) and (11, 5) to (5, 9) form obtuse angles

# Export the model to an STL file
result.val().exportStl("Refine_V_2.stl")
