
import cadquery as cq

# Create the main U-shaped body
U_shape = (
    cq.Workplane("XY")
    .moveTo(-1.5, 0)
    .lineTo(1.5, 0)
    .lineTo(1.5, 2)
    .lineTo(-1.5, 2)
    .close()
    .extrude(1)
)

# Adjusting the square on the left to slightly overlap with U's bottom left corner
square_left = (
    cq.Workplane("XY")
    .moveTo(-1.7, -0.1)  # Slight negative offset to ensure overlap
    .rect(1, 1)
    .extrude(1)
)

# Adjusting the square on the right to slightly overlap with U's bottom right corner
square_right = (
    cq.Workplane("XY")
    .moveTo(1.7, -0.1)  # Slight positive offset to ensure overlap
    .rect(1, 1)
    .extrude(1)
)

# Combining all parts into a single solid
result = U_shape.union(square_left).union(square_right)

# Export the final result to an STL file named "Refine_V_1.stl"
result.val().exportStl("Refine_V_1.stl")
