
import cadquery as cq

square_size = 10.0  # The edge length of the main square
rectangle_width = square_size / 5  # Width of the side rectangles, 1/5th of the square size
rectangle_length = square_size  # Length of the side rectangles matches the square
extrusion_length = 5.0  # Height of extrusions

# Start with a square base
result = cq.Workplane("XY").box(square_size, square_size, extrusion_length, centered=(True, True, False))

# Extrude the two side rectangles in the Z direction, opposite of the main square's extrusion
left_rect = result.faces("<Y").workplane(centerOption="CenterOfBoundBox").rect(rectangle_width, rectangle_length).extrude(-extrusion_length)
right_rect = result.faces(">Y").workplane(centerOption="CenterOfBoundBox").rect(rectangle_width, rectangle_length).extrude(-extrusion_length)

# Combine everything into a single shape
result = left_rect.union(right_rect)

# Export to STL
result.val().exportStl("Refine_V_1.stl")
