
import cadquery as cq

# Define the points for a simple "L" shape
points = [(0, 0), (0, 10), (2, 10), (2, 2), (10, 2), (10, 0)]

# Create the "L" shape using these points
l_shape = cq.Workplane("front").polyline(points).close()

# Extrude the "L" shape to give it thickness
result = l_shape.extrude(2)

# Export the result to an STL file
result.val().exportStl("Refine_V_1.stl")
