
import cadquery as cq

# Dimensions for the block
block_length = 20.0
block_width = 10.0
block_height = 5.0

# Stud dimensions, each stud is a quarter the height of the base block
stud_diameter = block_width / 4
stud_height = block_height / 4

# Create the base block
result = cq.Workplane("XY").box(block_length, block_width, block_height)

# Function to create a stud
def make_stud(x_offset):
    return (cq.Workplane("XY")
            .workplane(offset=block_height)  # move to top of the block
            .moveTo(x_offset, block_width / 2)  # align to the center width-wise
            .circle(stud_diameter / 2)
            .extrude(stud_height))

# Assign positions for studs, evenly spaced
stud_positions = [block_length / 6, block_length / 2, 5 * block_length / 6]

# Create studs and union with the base block
for pos in stud_positions:
    stud = make_stud(pos)
    result = result.union(stud)

# Retrieve solid and export as STL
result.val().exportStl("Refine_V_1.stl")
