
import cadquery as cq

# Dimensions for the rectangular block
block_length = 20.0
block_width = 10.0
block_height = 5.0

# Dimensions for the studs, ensuring they are 1/4th the size of the block
stud_diameter = block_width / 2  # Diameter is half the block width
stud_height = block_height / 4

# Create the main rectangular block
result = cq.Workplane("XY").box(block_length, block_width, block_height)

# Define function to create a single cylindrical stud
def make_stud(x_offset, y_offset):
    return (cq.Workplane("XY")
            .workplane(offset=-stud_height)  # Negative to push the studs downwards
            .center(x_offset, y_offset)
            .circle(stud_diameter / 2)
            .extrude(stud_height))

# Calculate positions based on block dimensions, adjusted to center the studs underneath
x_offset = block_length / 2
y_offset = block_width / 4

# Create two studs under the block
for dy in [-y_offset, y_offset]:  # Positions the studs symmetrically about the center on y-axis
    stud = make_stud(x_offset, dy)
    result = result.union(stud)

# Save the result to an STL file
result.val().exportStl("Refine_V_2.stl")
