
import cadquery as cq

outer_radius = 10.0
inner_radius = 5.0
height = 100.0

# Creating the outer and inner cylinders
outer_cylinder = cq.Workplane("XY").circle(outer_radius).extrude(height)
inner_cylinder = cq.Workplane("XY").circle(inner_radius).extrude(height)

# Creating a hollow cylinder by cutting the inner cylinder from the outer cylinder
hollow_cylinder = outer_cylinder.cut(inner_cylinder)

# Cutting a semi-circular shape in the middle of the cylinder
# Positioning the cutting half-sphere in the middle of the cylinder
cut_shape = cq.Workplane("YZ").workplane(offset=height/2)\
    .circle(outer_radius).extrude(-outer_radius, both=False).mirror("XZ")

# Performing the cut operation
result = hollow_cylinder.cut(cut_shape)

# Visualize the extrusion clearly by adding visual flares or marks
extrusion_marker = cq.Workplane("XY").circle(outer_radius + 0.2).extrude(height/100).translate((0, 0, height/2))
result = result.union(extrusion_marker)

# Exporting the model to an STL file
result.val().exportStl("Refine_V_1.stl")
