
import cadquery as cq

# Define the dimensions
outer_radius = 10.0
inner_radius = 5.0
height = 100.0

# Create the main hollow cylinder
outer_cylinder = cq.Workplane("XY").circle(outer_radius).extrude(height)
inner_cylinder = cq.Workplane("XY").circle(inner_radius).extrude(height)
hollow_cylinder = outer_cylinder.cut(inner_cylinder)

# Constructing the semi-circular cut by intersecting a box with a sphere and mirroring it to get the semi-circle
cut_shape = cq.Workplane("XY").workplane(offset=height/2)\
    .sphere(outer_radius).intersect(cq.Workplane("XY").box(outer_radius*2, outer_radius * 2, outer_radius).translate((0, 0, outer_radius/2)))\
    .mirror("XY")

# Cutting the semi-circle from the hollow cylinder
result = hollow_cylinder.cut(cut_shape)

# Export as STL
result.val().exportStl("Refine_V_2.stl")
