
import cadquery as cq

# Define the points to create a long isosceles triangle
points = [(0, 0), (5, 0), (2.5, 5)]

# Create the triangle and close the polyline to form the shape
result = cq.Workplane("XY").polyline(points).close().extrude(30)  # Extruding longer to emphasize length

# Export the result to an STL file
result.val().exportStl("Refine_V_1.stl")
