
import cadquery as cq

# Calculate the height of the isosceles triangle so that the two equal sides are truly equal
base_length = 5
height = (base_length**2 - (base_length/2)**2)**0.5  # Pythagorean theorem

points = [(0, 0), (5, 0), (2.5, height)]

result = cq.Workplane("XY").polyline(points).close().extrude(30)

result.val().exportStl("Refine_V_2.stl")
