
import cadquery as cq

# Define the parameters for the "R"
leg_height = 3.0
leg_width = 1.0
curve_radius = 1.0
thickness = 0.5

# Create the base rectangle for the vertical leg of "R"
leg = cq.Workplane("front").rect(leg_width, leg_height)

# Add the circular part for the "R"
half_circle = (
    cq.Workplane("front", origin=(leg_width/2, leg_height - curve_radius))
    .circle(curve_radius).extrude(leg_width)
)

# Using union to combine the leg and the half-circle
combined_shape = leg.union(half_circle)

# Extrude the 2D sketch to make it 3D
result = combined_shape.extrude(thickness)

# Save the model
result.val().exportStl("Refine_V_1.stl")
