
import cadquery as cq

# Define the dimensions of the brick
brick_length = 1.0
brick_width = 1.0
brick_height = 1.8
circle_height = brick_height / 7
circle_diameter = brick_width / 2

# Create the base of the brick
brick = (
    cq.Workplane("XY")
    .box(brick_length, brick_width, brick_height)
    .faces("<Z")
    .shell(-circle_height)
)

# Create the circle on top of the brick
brick = (
    brick.faces(">Z")
    .workplane()
    .circle(circle_diameter / 2)
    .extrude(circle_height)
)

brick.val().exportStl("Generated.stl")
