
import cadquery as cq

# Define dimensions based on the description
brick_length = 1.0
brick_width = 1.0
brick_height = 2.0  # Setting height almost twice the length of the square's side
stud_height = brick_height / 7
stud_diameter = brick_width / 2

# Create the main brick body
brick = (
    cq.Workplane("XY")
    .box(brick_length, brick_width, brick_height)
)

# Hollow out the interior while keeping a thin wall to define the hollow space
wall_thickness = 0.1
brick = (
    brick.faces("<Z")
    .shell(-wall_thickness)
)

# Adding the extruded circle on top of the cube
brick = (
    brick.faces(">Z")
    .workplane()
    .circle(stud_diameter / 2)
    .extrude(stud_height)
)

brick.val().exportStl("Refine_V_2.stl")
