
import cadquery as cq

# Define the sizes based on the descriptions.
main_square_size = 10.0  # Size of the base square
small_square_size = main_square_size / 5  # 1/5th the size of the large square

# Create the main square and extrude it.
result = (
    cq.Workplane("XY")
    .box(main_square_size, main_square_size, main_square_size)
)

# Position and subtract the smaller square.
result = (
    result
    .faces(">Z")
    .workplane(centerOption="CenterOfBoundBox")
    .transformed(offset=(4.0, 4.0, 0))  # Adjust to ensure the top-right corners align.
    .rect(small_square_size, small_square_size)
    .cutBlind(-main_square_size)  # Cut downwards into the object.
)

# Export the final result to STL.
result.val().exportStl("Refine_V_2.stl")
