
import cadquery as cq

outer_diameter = 20.0
width = 2.0
inner_diameter = outer_diameter - 2 * width
hole_diameter = 1.0

# Create the ring
ring = cq.Workplane("XY").circle(outer_diameter / 2).circle(inner_diameter / 2).extrude(width)

# Positions of the holes in a triangular arrangement
hole_positions = [(0, outer_diameter / 2 - width / 2), 
                  (outer_diameter / 2 - width / 2, 0), 
                  (0, -outer_diameter / 2 + width / 2)]

# Create holes at specified positions
for pos in hole_positions:
    ring = ring.faces(">Z").workplane().center(*pos).hole(hole_diameter)

# Save the model to an STL file
ring.val().exportStl("Refine_V_2.stl")
