
import cadquery as cq

length = 80.0
width = 60.0
thickness = 10.0

# Calculate the size of the hole to ensure it is 1/8th the volume of the rectangle block
hole_length = length / 2   # This and the next measurement will ensure the area of the hole is 1/8 of the rectangle's area
hole_width = width / 4

result = (
    cq.Workplane("XY")
    .rect(length, width)
    .extrude(thickness)
)

# Position the hole closer to the bottom. The y-coordinate should be adjusted more negatively.
result = (
    result.faces(">Z")
    .workplane(centerOption="CenterOfBoundBox")
    .rect(hole_length, hole_width)
    .translate((0, -3*width/8, 0))  # Reposition hole closer to the bottom
    .cutBlind(-thickness)
)

result.val().exportStl("Refine_V_2.stl")
