
import cadquery as cq

large_cylinder_diameter = 10.0
large_cylinder_height = 5.0
small_cylinder_diameter = large_cylinder_diameter / 2  # Clearly half the diameter
small_cylinder_height = large_cylinder_height * 5  # Five times the length

# Create the large cylinder
result = cq.Workplane("XY").circle(large_cylinder_diameter / 2).extrude(large_cylinder_height)

# Add the smaller cylinder by translating downwards and then extruding
result = result.faces("<Z").workplane(centerOption="CenterOfBoundBox").circle(small_cylinder_diameter / 2).extrude(-small_cylinder_height)

# Export in STL format
result.val().exportStl("Refine_V_2.stl")
