
import cadquery as cq

# Create a rectangle and extrude it
result = cq.Workplane("front").rect(10, 20).extrude(30)

# Center the circle in the rectangle for the hole; since the rectangle is 10x20, the center is at (5,10) from one corner
# However, using `centerRect` places the circle at the center without needing to calculate.
result = result.faces(">Z").workplane().center(0, 0).circle(5).cutThruAll()

# Save the result as an STL file
result.val().exportStl("Refine_V_1.stl")
