
import cadquery as cq

# Parameters
square_length = 10.0
square_width = 10.0
small_extrude_amount = 1.0  # Short extrusion for the base
rectangle_length = square_length  # Length of the rectangle equal to square base
rectangle_width = square_width / 2.0  # Half the square width for the rectangle
large_extrude_amount = 100.0  # Large extrusion to resemble a pillar

# Creating the model
result = (
    cq.Workplane("XZ")
    .rect(square_length, square_width)
    .extrude(small_extrude_amount)  # Extruding the square to form a base
    .faces(">Y")
    .workplane(centerOption="CenterOfMass")
    .rect(rectangle_length, rectangle_width)  # Create and center the rectangle on the square base
    .extrude(large_extrude_amount)  # Final extrusion to form the pillar
)

# Export the model to STL
result.val().exportStl("Refine_V_1.stl")
