
import cadquery as cq

square_length = 10.0
square_width = 10.0
small_extrude_amount = 1.0
rectangle_length = square_length
rectangle_width = square_width / 2.0
large_extrude_amount = 100.0

result = (
    cq.Workplane("XZ")
    .rect(square_length, square_width)
    .extrude(small_extrude_amount)
    .faces(">Y")
    .workplane(centerOption="CenterOfMass")
    .rect(rectangle_length, rectangle_width)
    .extrude(large_extrude_amount)
)

result.val().exportStl("Refine_V_2.stl")
