
import cadquery as cq

original_size = 10.0
original_extrusion = 1.0
hollow_size = original_size / 2
second_size = original_size * 3 / 4
second_extrusion = original_extrusion / 4
tiny_size = 0.5
tiny_extrusion = 0.1

result = cq.Workplane("XY").rect(original_size, original_size).extrude(original_extrusion)

# Rectangular hollow adjusted to extend through the entire original extrusion
result = result.faces(">Z").workplane().rect(hollow_size, hollow_size).cutBlind(-original_extrusion)

# Centered second shape
result = result.faces(">Z").workplane().rect(second_size, second_size).extrude(second_extrusion)

# Corrected tiny rectangles to extrude outwards
result = result.faces(">Z").workplane(centerOption='CenterOfBoundBox') \
    .transformed(offset=cq.Vector(-second_size/4, -second_size/4)) \
    .rect(tiny_size, tiny_size).extrude(tiny_extrusion)
result = result.faces(">Z").workplane(centerOption='CenterOfBoundBox') \
    .transformed(offset=cq.Vector(second_size/4, -second_size/4)) \
    .rect(tiny_size, tiny_size).extrude(tiny_extrusion)

# Save the modified design to STL
result.val().exportStl("Refine_V_2.stl")
