
import cadquery as cq

# Dimensions for the larger rectangle
large_rectangle_length = 10.0
large_rectangle_width = 5.0
large_rectangle_extrusion = 2.0

# Dimensions for the smaller rectangle (half the size of the larger one)
small_rectangle_length = large_rectangle_length / 2
small_rectangle_width = large_rectangle_width / 2
small_rectangle_extrusion = large_rectangle_extrusion * 1.8  # Adjust extrusion to be almost twice as much

# Creating the large rectangle extruded in the XY plane
large_rectangle = (
    cq.Workplane("XY")
    .rect(large_rectangle_length, large_rectangle_width)
    .extrude(large_rectangle_extrusion)
)

# Adjusting the position of the small rectangle to be centered and in the YZ plane
small_rectangle = (
    cq.Workplane("YZ")
    .center(0, large_rectangle_width / 2)  # Centering on the same point as the large rectangle
    .rect(small_rectangle_length, small_rectangle_width)
    .extrude(small_rectangle_extrusion)
)

# Union of both extruded shapes
result = large_rectangle.union(small_rectangle)

# Exporting the result to an STL file
result.val().exportStl("Refine_V_1.stl")
