
import cadquery as cq

# Define the points of the pentagon where the bottom is a rectangle
points = [(0, 0), (10, 0), (10, 5), (5, 10), (0, 10)]

# Create the pentagonal cross-section shape 
result = cq.Workplane("front").polyline(points).close()

# Extrude the pentagonal shape uniformly to form a prism
result = result.extrude(10)

# Export the result to an STL file
result.val().exportStl("Refine_V_2.stl")
