
import cadquery as cq

diameter = 100.0  # specified diameter
height = 10.0  # specified height

result = (
    cq.Workplane("XY")
    .circle(diameter / 2.0)
    .extrude(height)
)

# Adding visual markers: concentric circles on the top surface
number_of_circles = 5  # number of concentric circles
circle_spacing = (diameter / 2.0) / (number_of_circles + 1)

for i in range(1, number_of_circles + 1):
    result = result.faces(">Z").workplane().circle(circle_spacing * i).cutBlind(-0.1)  # Create slight indentations

result.val().exportStl("Refine_V_1.stl")
