
import cadquery as cq

# Increasing the diameter to emphasize its large size visually better.
diameter = 300.0  # Increased from 100.0 to 300.0
height = 10.0

result = (
    cq.Workplane("XY")
    .circle(diameter / 2.0)
    .extrude(height)
)

# Updating the circle spacing calculation due to the increased diameter.
number_of_circles = 5
circle_spacing = (diameter / 2.0) / (number_of_circles + 1)

for i in range(1, number_of_circles + 1):
    result = result.faces(">Z").workplane().circle(circle_spacing * i).cutBlind(-0.1)

# Saving the result in a new file as per the instruction to reflect the updates.
result.val().exportStl("Refine_V_2.stl")
