
import cadquery as cq

length = 10.0
width = 5.0
thickness = 2.0
hole_diameter = 1.0

# Creating the rectangle and extruding it
result = (
    cq.Workplane("XY")
    .rect(length, width)
    .extrude(thickness)
)

# Adjust hole position so it's clearly closer to the left side of the rectangle
# The hole now will be placed closer to one side by setting it to 2/3rd of half the length value towards left
hole_shift = -length * 1/3

result = (
    result.faces(">Z")
    .workplane()
    .center(hole_shift, 0)
    .hole(hole_diameter)
)

# Save the model
result.val().exportStl("Refine_V_1.stl")
