
import cadquery as cq

# Parameters
outer_diameter = 5.0
inner_diameter = 3.0
length = 10.0  # shortened length to emphasize shortness

# Create the cylindrical outer body
pipe_outer = cq.Workplane("front").cylinder(height=length, radius=outer_diameter/2)

# Create the inner cavity by another cylinder
pipe_inner = cq.Workplane("front").cylinder(height=length, radius=inner_diameter/2)

# Subtract inner cylinder from outer cylinder to create the hollow area
pipe = pipe_outer.cut(pipe_inner)

# Export the modeled pipe to STL
pipe.val().exportStl("Refine_V_1.stl")
