
import cadquery as cq

outer_width = 5.0
outer_height = 5.0
inner_width = 3.0
inner_height = 3.0
length = 10.0

# Create the outer rectangular pipe
pipe_outer = cq.Workplane("front").box(outer_width, outer_height, length)

# Create the inner hollow space
pipe_inner = cq.Workplane("front").box(inner_width, inner_height, length*1.2).translate((0, 0, length * -0.1))

# Cut the inner box from the outer box to create a hollow center
pipe = pipe_outer.cut(pipe_inner)

# Export the result as an STL file
pipe.val().exportStl("Refine_V_2.stl")
