
import cadquery as cq

length = 100.0
width = 10.0
height = 20.0
thickness = 2.0

# Create a basic rectangular prism
pipe = cq.Workplane("front").box(length, width, height)

# Hollow out the center to create the pipe effect
pipe = pipe.faces('<X').shell(-thickness)

# Adding fillets to simulate cylindrical shape along the length
pipe = pipe.edges('|Z').fillet(thickness * 0.75)

pipe.val().exportStl("Refine_V_1.stl")
