
import cadquery as cq

# Define dimensions
length = 100.0
width = 10.0
height = 20.0
thickness = 2.0
diameter = 6.0  # Diameter for cylindrical holes

# Create a box
pipe = cq.Workplane("front").box(length, width, height)

# Hollow out the box
pipe = pipe.faces('<X').shell(-thickness)

# Add cylindrical cutouts
# Cutting cylinders through the length of the box to make it appear more pipe-like
# The number and placement of these cylinders can be adjusted based on design needs.
# Here, placing one cylinder at the center for simplicity.
number_of_holes = 3
hole_spacing = length / (number_of_holes + 1)
for i in range(1, number_of_holes + 1):
    pipe = pipe.faces(">Z").workplane(centerOption="CenterOfBoundBox").pushPoints([(hole_spacing * i - length / 2, 0)]).hole(diameter, height)

# Export the model as STL
pipe.val().exportStl("Refine_V_2.stl")
