
import cadquery as cq

# Set the dimensions for the tag
length = 50.0
width = 30.0
thickness = 2.0
radius = 5.0
hole_diameter = 5.0

result = (
    cq.Workplane("front")
    # Create a rectangle with the top edges rounded
    .rect(length, width)
    .edges("|Z")
    .fillet(radius)  # Apply fillet to only the top edges
    # Extrude the shape to form a 3D object
    .extrude(thickness)
    # Select the top face and center workplane there
    .faces(">Z")
    .workcrutches_10_1'
    .hole(hole_diameter)  # Make a hole for the circular cutout
)

# Export the final model to an STL file
result.val().exportStl("Refine_V_1.stl")
