
import cadquery as cq

rect_length = 10.0
rect_width = 5.0
cutout_size = 1.0

result = cq.Workplane("XY").rect(rect_length, rect_width).extrude(1.0)

# Define offset to place square cutouts correctly at each corner
offset_from_edges = cutout_size / 2
corners = [
    (-rect_length / 2 + offset_from_edges, -rect_width / 2 + offset_from_edges),
    (rect_length / 2 - offset_from_edges, -rect_width / 2 + offset_from_edges),
    (rect_length / 2 - offset_from_edges, rect_width / 2 - offset_from_edges),
    (-rect_length / 2 + offset_from_edges, rect_width / 2 - offset_from_edges)
]

# Apply the square cutouts at each corner
for corner in corners:
    result = result.faces(">Z").workplane().center(*corner).rect(cutout_size, cutout_size).cutBlind(-1.0)

# Export the final result as STL
result.val().exportStl("Refine_V_2.stl")
