
import cadquery as cq

# Create a sketch of a rectangle
rectangle = cq.Workplane("XY").rect(10, 20)

# Extrude the rectangle
extruded_rectangle = rectangle.extrude(5)

# Add a circular hole at the center of the rectangle
result = extruded_rectangle.faces(">Z").workplane().hole(2)

# Save the output
result.val().exportStl("Generated.stl")
