
import cadquery as cq

# Create a sketch of a rectangle with right angles and the specific dimensions
rectangle = cq.Workplane("XY").rect(10, 20)

# Extrude the rectangle to create a rectangular prism
extruded_rectangle = rectangle.extrude(5)

# Select the top face of the extruded rectangle and add a circular hole at the center.
result = extruded_rectangle.faces(">Z").workplane().hole(2)

# Save the model to an STL file.
result.val().exportStl("Refine_V_1.stl")
