
import cadquery as cq
import math

# Define the side length of the octagon
side_length = 10.0

# Calculate the circumradius of the octagon
circumradius = side_length / (2 * math.sin(math.pi / 8))

# Create the octagon
result = (
    cq.Workplane("XY")
    .polygon(8, circumradius)
    .extrude(5.0)  # Extrude the octagon to create a 3D object
)

# Export the result to STL
result.val().exportStl("Generated.stl")
