
import cadquery as cq

# Create a basic rectangle and extrude to form a thin plate
result = cq.Workplane("front").rect(200, 300).extrude(2)

# Define the diameter of the holes
hole_diameter = 5
# Setting hole positions correctly with respect to the initial position (left side of the rectangle)
# Assuming the rectangle's y dimension is 300, 
# and setting holes at 25mm from the top and bottom edge respectively for uniformity
top_hole_position = (90, 150 - 25)  # Adjusted from axis center to approximate edge position
bottom_hole_position = (90, -150 + 25)

# Add holes at the specified positions
result = result.faces(">Y").workplane(centerOption="CenterOfBoundBox").pushPoints([top_hole_position, bottom_hole_position]).hole(hole_diameter)

# Export the result as an STL file
result.val().exportStl("Refine_V_2.stl")
