
import cadquery as cq

# Define the dimensions of the rectangle and trapezium
rect_length = 100.0
rect_width = 20.0
trap_height = 30.0
trap_top_length = 10.0

# Create the rectangle
result = cq.Workplane("front").rect(rect_length, rect_width)

# Move to the top center of the rectangle
result = result.moveTo(rect_length / 2, rect_width / 2)

# Draw the trapezium
result = result.lineTo(-(trap_top_length / 2), trap_height)
result = result.lineTo(trap_top_length / 2, trap_height)
result = result.lineTo(trap_top_length / 2, 0)
result = result.lineTo(-(trap_top_length / 2), 0)

# Close the sketch and extrude
result = result.close().extrude(rect_width)

# Export the result
result.val().exportStl("Generated.stl")
