
import cadquery as cq

# Dimensions
rect_length = 100.0
rect_width = 20.0
trap_height = 30.0
trap_base_length = 20.0  # Set this to be the same as rect_width to meet the requirement

# Create a rectangle
result = cq.Workplane("front").rect(rect_length, rect_width)

# Move to the top center of the rectangle to start the trapezium sketch
result = result.transformed(offset=(0, rect_width / 2, 0))

# Draw the trapezium (isosceles) centered on the Y-axis
result = result.polyline([
    (-trap_base_length / 2, 0),
    (-trap_base_length / 2 + (trap_base_length - rect_width) / 2, trap_height),
    (trap_base_length / 2 - (trap_base_length - rect_width) / 2, trap_height),
    (trap_base_length / 2, 0)
]).close()

# Extrude the combined sketch of the rectangle and trapezium
result = result.extrude(rect_width)

# Export the result to STL
result.val().exportStl("Refine_V_1.stl")
