
import cadquery as cq

# Dimensions
rect_length = 100.0
rect_width = 20.0
trap_height = 30.0

# Create a rectangle
result = cq.Workplane("front").rect(rect_length, rect_width)

# Move the working plane to the end of the rectangle and attach a trapezium
result = result.transformed(offset=(0, rect_width / 2, 0))
result = result.polyline([
    (-rect_width / 2, 0),
    (-rect_width / 2, trap_height),
    (rect_width / 2, trap_height),
    (rect_width / 2, 0)
]).close()

# Extrude the combined sketch
result = result.extrude(rect_width)

# Save the STL file with the adjustments
result.val().exportStl("Refine_V_2.stl")
