
import cadquery as cq

# Dimensions
rect_length = 10.0
rect_width = 9.0
trap_base = rect_width * 2 / 3  # Base of the trapezium
trap_top = trap_base - (trap_base / 5)  # Top of the trapezium, sides are 1/10th of the base each
trap_height = trap_base / 10  # Height of the trapezium
extrude_amount = 0.5

# Create a new workplane to draw the rectangle
result = cq.Workplane("front").rect(rect_length, rect_width).extrude(extrude_amount)

# Calculate center offset to align the trapezium
center_offset = (rect_length - trap_base) / 2

# Create a trapezium at the correct position
# Move to the right place in the center of the shorter edge, slightly to the right
trapezium = (cq.Workplane("front")
             .moveTo(center_offset + trap_base / 6, rect_width / 2 + extrude_amount)
             .polyline([(0, 0), (trap_base, 0)])
             .lineTo(trap_top / 2, trap_height)
             .lineTo(-trap_top / 2, trap_height)
             .close()
             .extrude(extrude_amount))

# Combine the trapezium with the main rectangle
final_result = result.union(trapezium)

# Export final result to STL
final_result.val().exportStl("Refine_V_1.stl")
