
import cadquery as cq

# Rectangle specifications
rect_length = 10.0  # length of the rectangle
rect_width = 9.0    # width of the rectangle

# Trapezium specifications
trap_base = rect_width * 2 / 3               # base of the trapezium
trap_height_ratio = 0.1                     # ratio of trap height to its base
trap_height = trap_base * trap_height_ratio  # height of the trapezium, 1/10th of the base
trap_side_length = trap_base / 10            # length of the angular sides, 1/10th of the base

# Determine the top length of the trapezium using the pythagorean theorem, assuming 45 degree angles
hypotenuse = trap_side_length
trap_top = trap_base - 2 * (hypotenuse / (2 ** 0.5))

# Extrusion amount
extrude_amount = 0.5

# Creating the base rectangle
result = cq.Workplane("front").rect(rect_length, rect_width).extrude(extrude_amount)

# Calculating the center offset for correct positioning of the trapezium
center_offset = (rect_length - trap_base) / 2 + trap_base / 6

# Creating the trapezium and positioning it correctly
trapezium = (cq.Workplane("front")
             .moveTo(center_offset, rect_width / 2 + extrude_amount)
             .polyline([(0, 0), (trap_base, 0)])
             .lineTo(trap_top / 2, trap_height)
             .lineTo(-trap_top / 2, trap_height)
             .close()
             .extrude(extrude_amount))

# Union the rectangle and the trapezium
final_result = result.union(trapezium)

# Export to STL file
final_result.val().exportStl("Refine_V_2.stl")
