
import cadquery as cq

# Define the dimensions of the pedestal
base_width, base_height = 10.0, 2.0
step_width, step_height = 6.0, 2.0
extrude_depth = 5.0

# Create a new workplane that represents the base level
pedestal = cq.Workplane("front").rect(base_width, base_height).extrude(extrude_depth)

# Offset moves the workplane up by base_height and centers it for the smaller rectangle
# No need to move center since we want the next step to be centered on the previous step
pedestal = pedestal.faces(">Z").workplane().center(0,0).rect(step_width, step_height).extrude(extrude_depth)

# Export the model as an STL file
pedestal.val().exportStl("Refine_V_1.stl")
