
import cadquery as cq

# Defining the dimensions for the base and the upper step
base_width, base_height = 10.0, 2.0
step_width, step_height = 6.0, 2.0
extrude_depth = 5.0

# Creating the base workplane
pedestal = cq.Workplane("front")

# Creating the base rectangle
pedestal = pedestal.rect(base_width, base_height)

# Moving upwards to the height of the base and adding the step rectangle
pedestal = pedestal.workplane(offset=base_height).rect(step_width, step_height)

# Extruding the combined shape in a single direction
pedestal = pedestal.loft(combine=True)

# Exporting the resulting model to an STL file
pedestal.val().exportStl("Refine_V_2.stl")
