
import cadquery as cq
import math

# Dimensions for the center triangle (equilateral)
center_triangle_height = 3
side_length = center_triangle_height / (math.sqrt(3)/2)

center_triangle = [
    (3 - side_length/2, 0),  # Base left
    (3 + side_length/2, 0),  # Base right
    (3, center_triangle_height)  # Apex
]

# Dimensions for the side triangles (scalene and acute-angled)
# Left triangle, all sides differ, manually calculated to be acute
left_triangle = [
    (0, 0),  # Base left
    (3 - side_length/2, 0),  # Base right (shared with center triangle)
    (1, 2.2)  # Apex, coordinates adjusted to achieve acuteness
]

# Right triangle
right_triangle = [
    (3 + side_length/2, 0),  # Base left (shared with center triangle)
    (6, 0),  # Base right
    (5, 2.2)  # Apex, coordinates adjusted to be acute
]

# Constructing the 3D model
result = cq.Workplane("front") \
    .polyline(left_triangle).close() \
    .polyline(center_triangle).close() \
    .polyline(right_triangle).close() \
    .extrude(1)  # Height of the extrusion

# Save the result
result.val().exportStl("Refine_V_2.stl")
