
import cadquery as cq

# Create a workplane that represents the base of the drawing
result = cq.Workplane("XY")

# Define two overlapping circles
result = result.circle(20).circle(15)

# Extrude these shapes to form a cylinder
result = result.extrude(100)

# Save the output as an STL file
result.val().exportStl("Refine_V_1.stl")
