
import cadquery as cq

# Define dimensions
length = 80.0  # Length of the rectangle
width = 20.0   # Width of the rectangle
thickness = 10.0  # Thickness of the rectangle

# Dimensions for the squares based on the feedback
square_size = length / 16  # Width of each square
square_thickness = thickness / 3  # Thickness of each square

# Create the base rectangle
result = (
    cq.Workplane("XY")
    .rect(length, width)
    .extrude(thickness)
)

# Add two squares to the center of the rectangle's shorter edge
for i in [-1, 1]:
    result = (
        result
        .faces(">Z")  # Work on the top face
        .workplane(centerOption="CenterOfBoundBox")
        .center(i * width / 2, 0)  # Centroing each square at half width apart on the top surface
        .rect(square_size, square_size)  # Use square size for both dimensions
        .extrude(square_thickness)  # Extrude the squares
    )

# Export the final model
result.val().exportStl("Refine_V_1.stl")
