
import cadquery as cq

# Define the points for a proper L shape with adjusted proportions
points = [(0, 0), (0, 30), (2, 30), (2, 2), (10, 2), (10, 0)]

# Create a L-shaped sketch by connecting the points
result = cq.Workplane("front").polyline(points).close()

# Extrude the sketch to turn it into a 3D object
result = result.extrude(1) 

# Export the result as an STL file
result.val().exportStl("Refine_V_1.stl")
