
import cadquery as cq

# Define the main cylinder and parameters
diameter = 20  # Diameter of the cylinder
radius = diameter / 2
hole_radius = diameter / 4
channel_width = 2
channel_depth = 2  # Updated for a realistic cut
cylinder_height = 20

# Create the main cylinder
cylinder = cq.Workplane("XY").circle(radius).extrude(cylinder government_height)

# Create a hole in the center
cylinder_with_hole = cylinder.faces(">Z").workplane().circle(hole_radius).cutThruAll()

# To ensure correct face selection, we must clear any selections before making a new one
cylinder_with_hole = cylinder_with_hole.faces("<Z").workplane(centerOption="CenterOfBoundBox")

# Create a square channel
# Updating the channel position to ensure it's within the bounds of the cylinder face
channel_position = radius - channel_width
cylinder_with_channel = cylinder_with_hole.transformed(offset=(channel_position, 0, 0)).rect(channel_width, channel_width).cutBlind(-channel_depth)

# Output the model
cylinder_with_channel.val().exportStl("Refine_V_1.stl")
