
import cadquery as cq

# Creating a rectangular shape and extruding it to form a 3D object
result = cq.Workplane("front").rect(20, 10).extrude(5)  # Dimensions adjusted for a clearer rectangle shape

# Defining the position and adding a circular hole in the top right corner of the top face
# Assuming that the top right corner of the rectangle would be near the edge of the length (20 units length and 10 units width rectangle)
hole_diameter = 1.5  # Diameter of hole, sized to be clearly visible
hole_position_from_right = 3  # Positioning the hole 3 units from the right edge
hole_position_from_front = 3  # Positioning the hole 3 units from the front edge
result = result.faces(">Z").workplane().center(hole_position_from_right - 20 / 2, 10 / 2 - hole_position_from_front).hole(hole_diameter)

# Exporting the model as STL
result.val().exportStl("Refine_V_1.stl")
